/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IRecipeContainer;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.api.mixin.stats.IRecipeBookMixin;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.items.crafting.NpcShapedRecipes;
import noppes.npcs.items.crafting.NpcShapelessRecipes;
import noppes.npcs.util.Util;

public class RecipeController
implements IRecipeHandler {
    public static ForgeRegistry<IRecipe> Registry;
    private static RecipeController instance;
    public static int version;
    private final Map<String, List<INpcRecipe>> globalList = new HashMap<String, List<INpcRecipe>>();
    private final Map<String, List<INpcRecipe>> modList = new HashMap<String, List<INpcRecipe>>();

    public static RecipeController getInstance() {
        if (instance == null) {
            instance = new RecipeController();
        }
        return instance;
    }

    public RecipeController() {
        instance = this;
        this.load();
    }

    public void checkSaves() {
        for (int i = 0; i < 2; ++i) {
            for (List<INpcRecipe> list : (i == 1 ? this.modList : this.globalList).values()) {
                for (INpcRecipe r : list) {
                    if (!r.isChanged()) continue;
                    this.save();
                    return;
                }
            }
        }
    }

    @Override
    public INpcRecipe addRecipe(String group, String name, boolean global, boolean isShaped, boolean isKnown, ItemStack result, ItemStack[][] stacks) {
        NonNullList list = NonNullList.func_191196_a();
        for (ItemStack[] ings : stacks) {
            list.add((Object)Ingredient.func_193369_a((ItemStack[])ings));
        }
        IRecipe recipe = isShaped ? new NpcShapedRecipes(group, name, global, (NonNullList<Ingredient>)list, result) : new NpcShapelessRecipes(group, name, global, (NonNullList<Ingredient>)list, result);
        recipe.setKnown(isKnown);
        return this.register((INpcRecipe)recipe);
    }

    @Override
    public INpcRecipe addRecipe(String group, String name, boolean global, boolean isShaped, boolean isKnown, ItemStack result, Object[] objects) {
        INpcRecipe recipe = isShaped ? NpcShapedRecipes.createRecipe(group, name, global, result, objects) : NpcShapelessRecipes.createRecipe(group, name, global, result, objects);
        recipe.setKnown(isKnown);
        return this.register(recipe);
    }

    public INpcRecipe addRecipe(String group, String name, Object ob, boolean global, boolean isKnown, boolean isShaped, Object ... objects) {
        ItemStack item;
        if (ob instanceof Item) {
            item = new ItemStack((Item)ob);
        } else if (ob instanceof Block) {
            item = new ItemStack((Block)ob);
        } else if (ob instanceof ItemStack) {
            item = (ItemStack)ob;
        } else {
            return null;
        }
        INpcRecipe recipe = isShaped ? NpcShapedRecipes.createRecipe(group, name, global, item, objects) : NpcShapelessRecipes.createRecipe(group, name, global, item, objects);
        recipe.setKnown(isKnown);
        return this.register(recipe);
    }

    public boolean delete(INpcRecipe recipe) {
        String group;
        Map<String, List<INpcRecipe>> map;
        if (recipe == null) {
            return false;
        }
        boolean isDel = false;
        IRecipe mcRecipe = (IRecipe)Registry.getValue(((IRecipe)recipe).getRegistryName());
        if (mcRecipe != null) {
            this.unregisterMCRecipe(mcRecipe);
        }
        if ((map = recipe.isGlobal() ? this.globalList : this.modList).containsKey(group = recipe.getNpcGroup())) {
            for (INpcRecipe rec : map.get(group)) {
                if (!rec.getName().equals(recipe.getName())) continue;
                isDel = map.get(group).remove(recipe);
                break;
            }
        }
        if (map.containsKey(group) && map.get(group).isEmpty()) {
            map.remove(group);
        }
        return isDel;
    }

    @Override
    public boolean delete(int id) {
        return this.delete(this.getRecipe(id));
    }

    @Override
    public boolean delete(boolean isGlobal, String group, String name) {
        return this.delete(this.getRecipe(isGlobal, group, name));
    }

    @Override
    public INpcRecipe[] getCarpentryData() {
        ArrayList<INpcRecipe> list = new ArrayList<INpcRecipe>();
        for (List<INpcRecipe> rs : this.modList.values()) {
            list.addAll(rs);
        }
        return list.toArray(new INpcRecipe[0]);
    }

    @Override
    public INpcRecipe[] getCarpentryRecipes(String group) {
        return this.modList.get(Util.instance.getResourceName(group)).toArray(new INpcRecipe[0]);
    }

    @Override
    public INpcRecipe[] getGlobalData() {
        ArrayList<INpcRecipe> list = new ArrayList<INpcRecipe>();
        for (List<INpcRecipe> rs : this.globalList.values()) {
            list.addAll(rs);
        }
        return list.toArray(new INpcRecipe[0]);
    }

    @Override
    public INpcRecipe[] getGlobalRecipes(String group) {
        return this.modList.get(Util.instance.getResourceName(group)).toArray(new INpcRecipe[0]);
    }

    public List<IRecipe> getKnownRecipes() {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (int i = 0; i < 2; ++i) {
            for (List<INpcRecipe> rs : i == 0 ? this.globalList.values() : this.modList.values()) {
                for (INpcRecipe recipe : rs) {
                    if (!recipe.isKnown() || Registry.getValue(((IRecipe)recipe).getRegistryName()) == null) continue;
                    list.add((IRecipe)recipe);
                }
            }
        }
        return list;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtFile = new NBTTagCompound();
        NBTTagList data = new NBTTagList();
        for (int i = 0; i < 2; ++i) {
            Map<String, List<INpcRecipe>> map = i == 0 ? this.globalList : this.modList;
            for (String groupName : map.keySet()) {
                NBTTagCompound nbtG = new NBTTagCompound();
                nbtG.func_74778_a("GroupName", groupName);
                nbtG.func_74757_a("isGlobal", i == 0);
                NBTTagList recipes = new NBTTagList();
                for (INpcRecipe recipe : map.get(groupName)) {
                    recipes.func_74742_a((NBTBase)recipe.getNbt().getMCNBT());
                }
                nbtG.func_74782_a("Recipes", (NBTBase)recipes);
                data.func_74742_a((NBTBase)nbtG);
            }
        }
        nbtFile.func_74782_a("Data", (NBTBase)data);
        nbtFile.func_74768_a("Version", version);
        return nbtFile;
    }

    @Override
    public INpcRecipe getRecipe(int id) {
        for (int i = 0; i < 2; ++i) {
            for (List<INpcRecipe> list : i == 0 ? this.globalList.values() : this.modList.values()) {
                for (INpcRecipe recipe : list) {
                    if (recipe.getId() != id) continue;
                    return recipe;
                }
            }
        }
        return null;
    }

    @Override
    public INpcRecipe getRecipe(boolean isGlobal, String group, String name) {
        IRecipe recipeMC = (IRecipe)Registry.getValue(new ResourceLocation("customnpcs", Util.instance.getResourceName(group + "_" + name)));
        if (recipeMC instanceof INpcRecipe) {
            return (INpcRecipe)recipeMC;
        }
        Map<String, List<INpcRecipe>> map = isGlobal ? this.globalList : this.modList;
        group = Util.instance.getResourceName(group);
        name = Util.instance.getResourceName(name);
        if (!map.containsKey(group)) {
            return null;
        }
        for (INpcRecipe recipe : map.get(group)) {
            if (!recipe.getName().equalsIgnoreCase(name)) continue;
            return recipe;
        }
        return null;
    }

    public void load() {
        CustomNpcs.debugData.start(null);
        LogWriter.info("Loading Recipes");
        this.loadFile();
        EventHooks.onGlobalRecipesLoaded(this);
        CustomNpcs.debugData.end(null);
    }

    private void loadDefaultRecipes(int version) {
        if (version == RecipeController.version && !this.modList.isEmpty() && !this.globalList.isEmpty()) {
            return;
        }
        if (this.globalList.containsKey("Npc Wand")) {
            for (INpcRecipe recOld : this.globalList.get("Npc Wand")) {
                this.delete(recOld);
            }
        }
        if (this.globalList.containsKey("Mob Cloner")) {
            for (INpcRecipe recOld : this.globalList.get("Mob Cloner")) {
                this.delete(recOld);
            }
        }
        if (this.globalList.containsKey("Soul Stone")) {
            for (INpcRecipe recOld : this.globalList.get("Soul Stone")) {
                this.delete(recOld);
            }
        }
        if (this.modList.containsKey("Npc MailBox")) {
            for (INpcRecipe recOld : this.modList.get("Npc MailBox")) {
                this.delete(recOld);
            }
        }
        if (this.modList.containsKey("Npc MailStand")) {
            for (INpcRecipe recOld : this.modList.get("Npc MailStand")) {
                this.delete(recOld);
            }
        }
        if (this.modList.containsKey("Npc MailStand Old")) {
            for (INpcRecipe recOld : this.modList.get("Npc MailStand Old")) {
                this.delete(recOld);
            }
        }
        ItemStack[] ingP = new ItemStack[]{new ItemStack(Items.field_151121_aF)};
        ItemStack[] ingS = new ItemStack[]{new ItemStack(Items.field_151055_y)};
        this.addRecipe("Carpentry Bench", "workbench", true, true, true, new ItemStack(CustomRegisters.carpentyBench), new ItemStack[][]{ingP, {new ItemStack(Items.field_151100_aR, 1, 4)}, {new ItemStack(Items.field_151042_j, 2, 0)}, ingS, {new ItemStack(Blocks.field_150344_f, 1, 0)}, ingS, ingS, {new ItemStack(Blocks.field_150344_f, 1, 1)}, ingS});
        ItemStack[] ingI = new ItemStack[]{new ItemStack(Items.field_151025_P), new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151172_bF)};
        INpcRecipe recipe = this.addRecipe("Npc Wand Edit", "Npc Wand", true, true, true, new ItemStack(CustomRegisters.wand), new ItemStack[][]{ingI, ingI, new ItemStack[0], new ItemStack[0], ingS, new ItemStack[0], new ItemStack[0], ingS, new ItemStack[0]});
        recipe.getAvailability().setGMOnly(true);
        recipe = this.addRecipe("Mob Cloner Edit", "Normal", CustomRegisters.cloner, true, true, true, "XX ", "XY ", " Y ", Character.valueOf('X'), Items.field_151025_P, Character.valueOf('Y'), Items.field_151055_y);
        recipe.getAvailability().setGMOnly(true);
        recipe = this.addRecipe("Mob Cloner Edit", "Potato", CustomRegisters.cloner, true, true, true, "XX ", "XY ", " Y ", Character.valueOf('X'), Items.field_151174_bG, Character.valueOf('Y'), Items.field_151055_y);
        recipe.getAvailability().setGMOnly(true);
        recipe = this.addRecipe("Mob Cloner Edit", "Carrot", CustomRegisters.cloner, true, true, true, "XX ", "XY ", " Y ", Character.valueOf('X'), Items.field_151172_bF, Character.valueOf('Y'), Items.field_151055_y);
        recipe.getAvailability().setGMOnly(true);
        ItemStack[] ingK = new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 15)};
        recipe = this.addRecipe("Soul Stone Empty", "Empty", true, false, true, new ItemStack(CustomRegisters.soulstoneEmpty), new ItemStack[][]{{new ItemStack(Items.field_151045_i)}, {new ItemStack(Items.field_151114_aO)}, {new ItemStack(Items.field_151137_ax)}, ingK});
        recipe.getAvailability().setDaytime(1);
        ItemStack[] ingR = new ItemStack[]{new ItemStack(Items.field_151042_j)};
        ItemStack[] ingL = new ItemStack[]{new ItemStack(Items.field_151100_aR, 3, 4)};
        this.addRecipe("Npc MailBox Blue", "Metallic", false, true, false, new ItemStack(CustomRegisters.mailbox, 1, 0), new ItemStack[][]{ingR, ingR, ingR, ingR, ingR, ingL, ingL, ingR, ingR, ingR, ingR, ingR, new ItemStack[0], ingP, ingK, new ItemStack[0]});
        ItemStack[] ingW = new ItemStack[]{new ItemStack(Blocks.field_150344_f, 1, 0), new ItemStack(Blocks.field_150344_f, 1, 1), new ItemStack(Blocks.field_150344_f, 1, 2), new ItemStack(Blocks.field_150344_f, 1, 3), new ItemStack(Blocks.field_150344_f, 1, 4), new ItemStack(Blocks.field_150344_f, 1, 5)};
        ItemStack[] ingC = new ItemStack[]{new ItemStack(Blocks.field_150347_e)};
        this.addRecipe("Npc MailStand Iron", "Metallic 0", false, true, true, new ItemStack(CustomRegisters.mailbox, 1, 1), new ItemStack[][]{ingW, ingW, ingW, new ItemStack[0], ingR, ingP, ingR, new ItemStack[0], ingW, ingW, ingW, new ItemStack[0], new ItemStack[0], ingC, new ItemStack[0], new ItemStack[0]});
        this.addRecipe("Npc MailStand Iron", "Metallic 1", false, true, true, new ItemStack(CustomRegisters.mailbox, 1, 1), new ItemStack[][]{ingR, ingP, ingR, new ItemStack[0], ingW, ingW, ingW, new ItemStack[0], ingW, ingW, ingW, new ItemStack[0], new ItemStack[0], ingC, new ItemStack[0], new ItemStack[0]});
        this.addRecipe("Npc MailStand Iron", "Metallic 2", false, true, true, new ItemStack(CustomRegisters.mailbox, 1, 1), new ItemStack[][]{new ItemStack[0], ingW, ingW, new ItemStack[0], ingR, ingW, ingW, ingR, new ItemStack[0], ingW, ingW, new ItemStack[0], new ItemStack[0], ingC, ingP, new ItemStack[0]});
        this.addRecipe("Npc MailStand Wood", "Wooden 0", false, true, true, new ItemStack(CustomRegisters.mailbox, 1, 2), new ItemStack[][]{ingW, ingW, ingW, new ItemStack[0], ingW, ingP, ingW, new ItemStack[0], ingW, ingW, ingW, new ItemStack[0], new ItemStack[0], ingC, new ItemStack[0], new ItemStack[0]});
        this.addRecipe("Npc MailStand Wood", "Wooden 1", false, true, true, new ItemStack(CustomRegisters.mailbox, 1, 2), new ItemStack[][]{ingW, ingP, ingW, new ItemStack[0], ingW, ingW, ingW, new ItemStack[0], ingW, ingW, ingW, new ItemStack[0], new ItemStack[0], ingC, new ItemStack[0], new ItemStack[0]});
        this.addRecipe("Npc MailStand Wood", "Wooden 2", false, true, true, new ItemStack(CustomRegisters.mailbox, 1, 2), new ItemStack[][]{new ItemStack[0], ingW, ingW, new ItemStack[0], ingW, ingW, ingW, ingW, new ItemStack[0], ingW, ingW, new ItemStack[0], new ItemStack[0], ingC, ingP, new ItemStack[0]});
    }

    private void loadFile() {
        try {
            File file = new File(CustomNpcs.Dir, "recipes.dat");
            if (file.exists()) {
                try {
                    NBTTagCompound nbtFile = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                    this.loadNBTData(nbtFile);
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            } else {
                this.globalList.clear();
                this.modList.clear();
                this.loadDefaultRecipes(-1);
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
            try {
                File file2 = new File(CustomNpcs.Dir, "recipes.dat_old");
                if (file2.exists()) {
                    try {
                        NBTTagCompound nbtFile = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file2.toPath(), new OpenOption[0]));
                        this.loadNBTData(nbtFile);
                    }
                    catch (Exception err) {
                        LogWriter.error(err);
                    }
                }
            }
            catch (Exception ee) {
                LogWriter.error(ee);
            }
        }
    }

    public void loadNBTData(NBTTagCompound nbtFile) {
        this.globalList.clear();
        this.modList.clear();
        if (nbtFile.func_150297_b("Data", 9) && version == nbtFile.func_74762_e("Version")) {
            for (int i = 0; i < nbtFile.func_150295_c("Data", 10).func_74745_c(); ++i) {
                Map<String, List<INpcRecipe>> map;
                NBTTagCompound nbtG = nbtFile.func_150295_c("Data", 10).func_150305_b(i);
                if (!nbtG.func_150297_b("GroupName", 8)) continue;
                Map<String, List<INpcRecipe>> map2 = map = nbtG.func_74767_n("isGlobal") ? this.globalList : this.modList;
                if (!map.containsKey(nbtG.func_74779_i("GroupName"))) {
                    map.put(nbtG.func_74779_i("GroupName"), new ArrayList());
                }
                for (int j = 0; j < nbtG.func_150295_c("Recipes", 10).func_74745_c(); ++j) {
                    NBTTagCompound nbtRecipe = nbtG.func_150295_c("Recipes", 10).func_150305_b(j);
                    this.loadNBTRecipe(nbtRecipe);
                }
            }
        }
        this.loadDefaultRecipes(nbtFile.func_74762_e("Version"));
    }

    public void loadNBTRecipe(NBTTagCompound nbtRecipe) {
        this.register((INpcRecipe)(!nbtRecipe.func_74764_b("IsShaped") || nbtRecipe.func_74767_n("IsShaped") ? NpcShapedRecipes.read(nbtRecipe) : NpcShapelessRecipes.read(nbtRecipe)));
    }

    public INpcRecipe register(INpcRecipe recipe) {
        if (recipe == null) {
            return null;
        }
        IRecipe mcRecipe = (IRecipe)Registry.getValue(((IRecipe)recipe).getRegistryName());
        if (!(mcRecipe instanceof INpcRecipe && ((INpcRecipe)mcRecipe).isGlobal() == recipe.isGlobal() && ((INpcRecipe)mcRecipe).getNpcGroup().equals(recipe.getNpcGroup()) && ((INpcRecipe)mcRecipe).getName().equals(recipe.getName()) && ((INpcRecipe)mcRecipe).isShaped() == recipe.isShaped())) {
            boolean isReset = false;
            if (mcRecipe != null) {
                if (mcRecipe instanceof INpcRecipe && ((INpcRecipe)mcRecipe).isGlobal() == recipe.isGlobal() && ((INpcRecipe)mcRecipe).isShaped() == recipe.isShaped()) {
                    isReset = true;
                    ((INpcRecipe)mcRecipe).setNbt(recipe.getNbt());
                    recipe = (INpcRecipe)mcRecipe;
                }
                if (!isReset) {
                    this.unregisterMCRecipe(mcRecipe);
                }
            }
            if (!isReset) {
                recipe = this.registryMCRecipe((IRecipe)recipe);
            } else {
                LogWriter.info("Reset NPC recipe: \"" + ((IRecipe)recipe).getRegistryName() + "\"; " + (recipe.isGlobal() ? "is Global" : "is Mod") + "; group: \"" + recipe.getNpcGroup() + "\"; name: \"" + recipe.getName() + "\"");
            }
        } else {
            ((INpcRecipe)mcRecipe).setNbt(recipe.getNbt());
            recipe = (INpcRecipe)mcRecipe;
            LogWriter.info("Reset NPC recipe: \"" + ((IRecipe)recipe).getRegistryName() + "\"; " + (recipe.isGlobal() ? "is Global" : "is Mod") + "; group: \"" + recipe.getNpcGroup() + "\"; name: \"" + recipe.getName() + "\"");
        }
        Map<String, List<INpcRecipe>> map = recipe.isGlobal() ? this.globalList : this.modList;
        ItemStack mainStack = null;
        if (!map.containsKey(recipe.getNpcGroup())) {
            map.put(recipe.getNpcGroup(), new ArrayList());
            mainStack = recipe.getProduct().getMCItemStack();
            if (recipe instanceof NpcShapedRecipes) {
                ((NpcShapedRecipes)recipe).main = true;
            } else {
                ((NpcShapelessRecipes)recipe).main = true;
            }
        } else {
            for (INpcRecipe npcRec : map.get(recipe.getNpcGroup())) {
                if (!npcRec.isMain()) continue;
                mainStack = npcRec.getProduct().getMCItemStack();
                break;
            }
        }
        if (!map.get(recipe.getNpcGroup()).remove(recipe)) {
            for (INpcRecipe npcRecipe : map.get(recipe.getNpcGroup())) {
                if (!npcRecipe.getName().equals(recipe.getName()) || npcRecipe.equal(recipe)) continue;
                map.get(recipe.getNpcGroup()).remove(npcRecipe);
                break;
            }
        }
        if (mainStack != null) {
            for (INpcRecipe npcRecipe : map.get(recipe.getNpcGroup())) {
                ItemStack cms = mainStack.func_77946_l();
                cms.func_190920_e(((IRecipe)npcRecipe).func_77571_b().func_190916_E());
                npcRecipe.setRecipeOutput(cms);
            }
        }
        map.get(recipe.getNpcGroup()).add(recipe);
        this.sendToAll(recipe);
        CustomNpcs.proxy.applyRecipe(recipe, true);
        this.save();
        return recipe;
    }

    private void unregisterMCRecipe(IRecipe recipe) {
        if (!(recipe instanceof INpcRecipe) || recipe.getRegistryName() == null) {
            return;
        }
        boolean isLocked = Registry.isLocked();
        if (isLocked) {
            Registry.unfreeze();
        }
        this.sendToAllRemove(((INpcRecipe)recipe).getId());
        Registry.remove(recipe.getRegistryName());
        CustomNpcs.proxy.applyRecipe((INpcRecipe)recipe, false);
        if (isLocked) {
            Registry.freeze();
        }
        LogWriter.debug("Unregister NPC recipe: \"" + recipe.getRegistryName() + "\"; " + (((INpcRecipe)recipe).isGlobal() ? "is Global" : "is Mod") + "; group: \"" + ((INpcRecipe)recipe).getNpcGroup() + "\"; name: \"" + ((INpcRecipe)recipe).getName() + "\"");
    }

    private INpcRecipe registryMCRecipe(IRecipe recipe) {
        INpcRecipe recipeMod;
        boolean isLocked = Registry.isLocked();
        if (isLocked) {
            Registry.unfreeze();
        }
        Registry.register((IForgeRegistryEntry)recipe);
        int id = Registry.getID(recipe.getRegistryName());
        if (recipe instanceof NpcShapedRecipes) {
            ((NpcShapedRecipes)recipe).id = id;
        } else {
            ((NpcShapelessRecipes)recipe).id = id;
        }
        if (isLocked) {
            Registry.freeze();
        }
        if ((recipeMod = (INpcRecipe)Registry.getValue(recipe.getRegistryName())) == null) {
            LogWriter.debug("Error Registry NPC recipe: \"" + recipe.getRegistryName() + "\"; " + (((INpcRecipe)recipe).isGlobal() ? "is Global" : "is Mod") + "; group: \"" + ((INpcRecipe)recipe).getNpcGroup() + "\"; name: \"" + ((INpcRecipe)recipe).getName() + "\"");
        } else {
            LogWriter.debug("Registry NPC recipe: \"" + recipe.getRegistryName() + "\"; " + (recipeMod.isGlobal() ? "is Global" : "is Mod") + "; group: \"" + recipeMod.getNpcGroup() + "\"; name: \"" + recipeMod.getName() + "\"");
        }
        return recipeMod;
    }

    public void save() {
        CustomNpcs.debugData.start(null);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(new File(CustomNpcs.Dir, "recipes.dat").toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    public void clear() {
        RecipeController.getInstance().globalList.clear();
        RecipeController.getInstance().modList.clear();
    }

    public void deleteGroup(boolean isGlobal, String group) {
        if (CustomNpcs.Server == null) {
            return;
        }
        Map<String, List<INpcRecipe>> map = isGlobal ? this.globalList : this.modList;
        if (map.containsKey(group = Util.instance.getResourceName(group))) {
            for (INpcRecipe rec : map.get(group)) {
                this.unregisterMCRecipe((IRecipe)Registry.getValue(((IRecipe)rec).getRegistryName()));
            }
            map.remove(group);
        }
    }

    public void renameGroup(boolean isGlobal, String oldGroupName, String newGroupName) {
        if (CustomNpcs.Server == null) {
            return;
        }
        Map<String, List<INpcRecipe>> map = isGlobal ? this.globalList : this.modList;
        oldGroupName = Util.instance.getResourceName(oldGroupName);
        newGroupName = Util.instance.getResourceName(newGroupName);
        if (map.containsKey(oldGroupName)) {
            ArrayList list = new ArrayList(map.get(oldGroupName));
            for (INpcRecipe recipe : list) {
                this.unregisterMCRecipe((IRecipe)recipe);
                map.get(oldGroupName).remove(recipe);
                NBTTagCompound compound = recipe.getNbt().getMCNBT();
                compound.func_74778_a("Group", newGroupName);
                recipe = recipe.isShaped() ? NpcShapedRecipes.read(compound) : NpcShapelessRecipes.read(compound);
                this.register(recipe);
            }
            map.remove(oldGroupName);
        }
        this.updateGroupToAll(isGlobal, newGroupName);
    }

    public void renameRecipe(boolean isGlobal, String oldRecipeName, String group, String newRecipeName) {
        Map<String, List<INpcRecipe>> map;
        if (CustomNpcs.Server == null) {
            return;
        }
        group = Util.instance.getResourceName(group);
        oldRecipeName = Util.instance.getResourceName(oldRecipeName);
        newRecipeName = Util.instance.getResourceName(newRecipeName);
        Map<String, List<INpcRecipe>> map2 = map = isGlobal ? this.globalList : this.modList;
        if (map.containsKey(group)) {
            ArrayList list = new ArrayList(map.get(group));
            boolean foundMainStack = false;
            for (INpcRecipe recipe : list) {
                if (!recipe.getName().equals(oldRecipeName)) continue;
                this.unregisterMCRecipe((IRecipe)recipe);
                map.get(group).remove(recipe);
                NBTTagCompound compound = recipe.getNbt().getMCNBT();
                compound.func_74778_a("Name", newRecipeName);
                if (compound.func_74767_n("IsMain")) {
                    if (foundMainStack) {
                        compound.func_74757_a("IsMain", false);
                    }
                    foundMainStack = true;
                }
                recipe = recipe.isShaped() ? NpcShapedRecipes.read(compound) : NpcShapelessRecipes.read(compound);
                this.register(recipe);
            }
        }
    }

    public void updateGroupToAll(boolean isGlobal, String group) {
        if (group == null) {
            return;
        }
        group = Util.instance.getResourceName(group);
        if (CustomNpcs.Server == null || !CustomNpcs.Server.func_71262_S() || !(isGlobal ? this.globalList : this.modList).containsKey(group) || (isGlobal ? this.globalList : this.modList).get(group).isEmpty()) {
            return;
        }
        for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            for (INpcRecipe recipe : (isGlobal ? this.globalList : this.modList).get(group)) {
                if (recipe == null) continue;
                Container container = player.field_71070_bA;
                if (container instanceof ContainerWorkbench || container instanceof ContainerPlayer || container instanceof IRecipeContainer) {
                    player.field_71070_bA.func_75134_a((EntityPlayer)player);
                }
                Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.RecipesData, recipe.getNbt().getMCNBT()});
            }
        }
    }

    public void sendToAllRemove(int id) {
        if (CustomNpcs.Server == null || !CustomNpcs.Server.func_71262_S() || this.getRecipe(id) == null) {
            return;
        }
        for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            Server.sendData(player, EnumPacketClient.SYNC_REMOVE, new Object[]{EnumSync.RecipesData, id});
        }
    }

    public void sendToAll(INpcRecipe recipe) {
        if (CustomNpcs.Server == null || !CustomNpcs.Server.func_71262_S()) {
            return;
        }
        for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            this.checkRecipeBook(player);
            if (recipe == null) {
                this.sendTo(player);
                continue;
            }
            Container container = player.field_71070_bA;
            if (container instanceof ContainerWorkbench || container instanceof ContainerPlayer || container instanceof IRecipeContainer) {
                player.field_71070_bA.func_75134_a((EntityPlayer)player);
            }
            Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.RecipesData, recipe.getNbt().getMCNBT()});
        }
    }

    public void sendTo(EntityPlayerMP player) {
        this.checkRecipeBook(player);
        Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.RecipesData, new NBTTagCompound()});
        for (int i = 0; i < 2; ++i) {
            for (List<INpcRecipe> list : i == 0 ? this.globalList.values() : this.modList.values()) {
                for (INpcRecipe recipe : list) {
                    Server.sendData(player, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.RecipesData, recipe.getNbt().getMCNBT()});
                }
            }
        }
    }

    public void checkRecipeBook(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        if (((IRecipeBookMixin)player.func_192037_E()).npcs$checkRecipes()) {
            player.func_192037_E().func_192826_c(player);
        }
    }

    static {
        version = 3;
    }
}

